
import React from 'react'
import { Navbar } from '@/components/Navbar';
import Footer from '@/components/Footer';
import Image from 'next/image';
export default function Service({ params }) {

    const { id } = params;

    const services = [
        {
            slug: 'haircut-hair-colouring',
            name: 'Haircut & Hair Colouring',
            img: '/images/1.webp',
            description: `Transform your look with our expert haircut and coloring services designed to bring out your unique style. At Toni & Guy, we believe that a haircut is more than just a trim – it’s an art form.\n\n Our experienced stylists specialize in personalized cuts that complement your face shape, hair texture, and lifestyle. \n\nWhether you're looking for a bold change or subtle enhancements, we ensure precision and creativity in every cut.Our color services offer a spectrum of possibilities, from soft highlights and balayage to vibrant shades and color corrections.We use top- quality products to maintain your hair’s health and enhance its natural radiance.For men, women, and children, we cater to all ages and style preferences, offering customized cuts and colors that suit your vision.Indulge in our deep conditioning treatments to revitalize and nourish your hair, leaving it soft, shiny, and manageable.With Toni & Guy, experience the art of hairdressing that not only elevates your look but also boosts your confidence.`,
            serv: [
                "MEN’S CUT & STYLING",

                "WOMEN’S CUT & BLOW DRY",

                "BLOW DRY",


                "SHAVE",

                "COLOR SERVICES",
                "TINT RE-GROWTH",
                "GLOBAL COLOR",

                "MEN’S CAP HIGHLIGHTS",
                "HIGHLIGHTS FULL HEAD",
                "HIGHLIGHTS HALF HEAD",
                "T-SECTION",
                "Hairline highlights",
                "PER STREAK",
                "MOUSTACHE COLOR",
                "BEARD COLOR",
                "COLOR CHANGE/CORRECTION",
                "PRE LIGHT / TONER",
                "Ultimate blonde ambition",
                "ADVANCE COLOR TECHNIQUE",
            ]
        },

        {
            slug: 'hair-treatment',
            name: 'Hair Treatment',
            img: '/images/2.jpg',
            description: `Revitalize your hair with our specialized hair treatment services tailored to meet diverse hair needs. Our hair treatments are crafted to address specific concerns such as dryness, damage, frizz, and loss of elasticity. From permanent straightening to curl-enhancing scrunching and professional-grade hair spa treatments, we provide a range of solutions designed for lasting results. Whether you're looking for the sleek finish of straightening or the hydrating benefits of a nourishing hair spa, our treatments utilize high-quality, salon-grade products for effective results. For those needing deep repair, our Re-Born and WELLAPLEX treatments restore strength and resilience to weakened hair, leaving it healthier and shinier. Experience our advanced hair care techniques, expertly applied to bring out your hair’s natural beauty and manageability, no matter your hair type or length.`,
            serv: [
                "STRAIGHTENING/ SMOOTHENING/ REBONDING",

                "CYSTEINE/KERATIN",
                "SHEA HAIR RETENTION TREATMENT",

                "SHEA HAIR CURL TREATMENT",

                "RE-BORN TREATMENT",

                "SEBASTIAN PROFESSIONAL TREATMENT",

                "WELLAPLEX",
                "BOTOX",
                "BOTOLISS",
                "WELLAPLEX CARE SPA"
            ]
        },

        {
            slug: 'bridal',
            name: 'Bridal',
            img: '/images/3.jpg',
            description: 'Make your special day unforgettable with our comprehensive bridal services. Our offerings include tailored bridal packages that ensure every bride and groom looks their best, from pre-wedding pampering to on-the-day styling. Our skilled team collaborates with you to achieve the look that complements your wedding theme, with trial sessions for complete confidence. We cover every detail, including skincare, makeup, hairstyling, and even bridesmaid styling, using only premium-quality products to give you a radiant look that lasts throughout the day.',
            serv: [
                "PRE-BRIDEGROOM PACKAGE - PREMIUM",
                "PRE-BRIDEGROOM PACKAGE - LUXURY",
                "Jeannot Ceuticals Facial",
                "BRIDAL MAKEUP & HAIR STYLING",
                "BRIDESMAIDS",
                "HAIR EXTENSIONS (By Consultation)",
                "PRE BRIDAL PACKAGE - LUXURY",
                "BRIDAL (HAIR, MAKEUP & SAREE DRAPING)",

                "GROOM (HAIR & MAKEUP)",

                "OUTDOOR SERVICES",

            ]
        },

        {
            slug: 'spa',
            name: 'Spa',
            img: '/images/4.jpg',
            description: 'Indulge in our relaxing spa treatments designed to rejuvenate your mind and body. Our spa services include soothing massages, refreshing facials, and revitalizing body scrubs. Each treatment is customized to meet your individual needs, helping you to unwind and escape from the stresses of daily life in a tranquil environment.',
            serv: [
                "REFLEXOLOGY",
                "SCRUBS & WRAPS",
                "MASSAGES", "SKIN CARE",
                "DRY & DEHYDRATED SKIN",
                "OILY SKIN & ACNE",
                "AGEING SKIN", "SENSITIVE & SENSITISED SKIN",
                " MANICURE & PEDICURE",
                "NAILS", "De-TAN",
                "THREADING", "WAXING"
            ]
        }
    ];

    // Find the service based on the slug
    const service = services.find(s => s.slug === id);

    // If the service isn't found or slug isn't ready, show a loading message
    if (!service) {
        return <div>Loading...</div>;
    }

    return (
        <>
            <Navbar />

            <div className="flex flex-col items-center justify-center bg-slate-950 h-80">
                <div className='h-32 w-full'></div>
                <h1 className="lg:text-8xl md:text-5xl text-4xl font-bold uppercase text-white">{service.name}</h1>
            </div>

            <div className="flex flex-col container lg:flex-row items-center mx-auto lg:items-start gap-8 px-4 py-10">
                {/* Image Section */}
                <div className="lg:w-1/2 lg:sticky top-20">
                    <Image className="w-full" src={service.img} width={500} height={500} alt={service.name} />
                </div>

                {/* Content Section */}
                <div className="lg:w-full space-y-6">
                    <p className="text-gray-800">{service.description}</p>
                    <h2 className="text-xl font-semibold">Services Offered:</h2>
                    <ul className="list-disc list-inside space-y-2">
                        {service.serv.map((s, index) => (
                            <li className='font-semibold' key={index}>{s}</li>
                        ))}
                    </ul>
                </div>
            </div>

            <Footer />
        </>
    );
}
